
#include <cstdio>
#include <iostream>
#include <vector>
#include <algorithm>
#include <cstring>
#include <string>
#include <cmath>
#include <map>
#include <set>
#include <climits>
#include <cassert>
#include <cctype>
using namespace std;

typedef long long ll;
typedef double dbl;
typedef long double ld;

#define mp make_pair
#define pb push_back
#define sz(x) (int)x.size()
#define all(x) x.begin(),x.end()
#define X first
#define Y second

const int maxn = 1000 * 100 + 1;
const dbl eps = (dbl)1e-6;
const ll mod = (ll)1e9 + 7;

int vw[maxn], pf[maxn], th[maxn], vf[maxn];
dbl karr[maxn], barr[maxn];
bool aa[maxn];

int main() {
	freopen("input.txt", "r", stdin);
	freopen("output.txt", "w", stdout);
	
	while (true) {
		int n;
		scanf("%d", &n);

		if (n == 0)
			break;

		int pw;
		scanf("%d", &pw);
		vector< pair<dbl, int> > v;
		
		dbl k = (dbl)pw, b = 0;
		for (int i = 0; i < n; i++) {
			scanf("%d%d%d%d", &vw[i], &pf[i], &vf[i], &th[i]);
			karr[i] = -(dbl)(pf[i] * vw[i]) / (dbl)vf[i];
			barr[i] = (dbl)(th[i] * pf[i]) / (dbl)vf[i];
			if (vw[i] > 0) {
				aa[i] = true;
				k += karr[i];
				b += barr[i];
			} else {
				aa[i] = false;
			}
			if (vw[i] != 0) v.pb(mp((dbl)th[i] / (dbl)vw[i], i));
			else b += barr[i];
		}

		sort(all(v));

		int j = 0;
		while (j < sz(v) && v[j].X < 0) {
			if (aa[v[j].Y]) {
				b -= barr[v[j].Y];
				k -= karr[v[j].Y];
			} else {
				b += barr[v[j].Y];
				k += karr[v[j].Y];
			}
			aa[v[j].Y] = 1 - aa[v[j].Y];
			j++;
		}

		dbl ans = b;
		while (j < sz(v)) {
			if (aa[v[j].Y]) {
				b -= barr[v[j].Y];
				k -= karr[v[j].Y];
			} else {
				b += barr[v[j].Y];
				k += karr[v[j].Y];
			}
			aa[v[j].Y] = 1 - aa[v[j].Y];
			ans = min(ans, k * v[j].X + b);
			j++;
		}

		printf("%.7lf\n", ans);
	}

	return 0;
}